IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Cbtes_Calc_Intereses') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Cbtes_Calc_Intereses
END
GO


CREATE PROCEDURE [dbo].[CPJ_Cbtes_Calc_Intereses] @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON 

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @pId_Trans				INT
DECLARE @pImp_Total				DECIMAL(12,2)
DECLARE @pImp_Abonado			DECIMAL(12,2)
DECLARE @pFecha_Pago			DATETIME


SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Trans					= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Trans')), 0)
SET @pImp_Total					= ISNULL(CONVERT(DECIMAL(12,2), dbo.CF_JSON_VALUE(@pJson,'Imp_Total')), 0)
SET @pImp_Abonado				= ISNULL(CONVERT(DECIMAL(12,2), dbo.CF_JSON_VALUE(@pJson,'Imp_Abonado')), 0)
SET @pFecha_Pago				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Pago')), 0)
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored						INT
DECLARE @rtaMsjStored						VARCHAR(4000)
DECLARE @Result_Stored_Invocado				INT
DECLARE @JSON_Parametros_Stored_Invocado	VARCHAR(8000)
/*FIN Variable de Retorono del Stored*/

/*Declaracion Variables Locales*/
DECLARE @Id_Producto			VARCHAR(14)
DECLARE @Descripcion			VARCHAR(150)
DECLARE @Importe				DECIMAL(16,2)
DECLARE @Periodo				DATETIME
DECLARE @Porcentaje				DECIMAL(12,5)
DECLARE @Porc_Bonif				DECIMAL(12,5)
DECLARE @Coef_Imp_Pagado		DECIMAL(15,5)
DECLARE @Fecha_Factura			DATETIME
DECLARE @Id_Cond_Pago_Cbte		SMALLINT
DECLARE @Id_Cond_Pago_Cbte_Item	SMALLINT
DECLARE @Item					SMALLINT
DECLARE @Plazo					INT
DECLARE @Porc_Bonif_Rec			DECIMAL(12,5)
DECLARE @Fecha_Rec				DATETIME
DECLARE @Dif_Dias				INT
DECLARE @Flag_Encontro			TINYINT
DECLARE @Plazo_Desde			INT
DECLARE @Porc_Bonif_Cbtes_Cond_Pago_Item DECIMAL(12,5)
DECLARE @Plazo_Bonif			BIGINT
DECLARE @Id_Cond_Pago_Item		INT
DECLARE @Tipo					CHAR(1)
DECLARE @Plazo_Sin_Recargo		INT
DECLARE @Imp_Final				DECIMAL(15,5)
DECLARE @Flag_Mes				TINYINT
DECLARE @Fecha_QA				DATETIME
DECLARE @Param_Prod_Recargos	VARCHAR(14)
/*Fin de Declaraciones Variables Locales */

/*Tabla de Respuesta*/
DECLARE @tRespuesta TABLE (
	Id_Producto VARCHAR(14),
	Descripcion VARCHAR(150),
	Importe		DECIMAL(16,2),
	Periodo		DATETIME,
	Porcentaje	DECIMAL(12,5),
	Id_Trans	INT
	)


BEGIN TRY

	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Cbtes_Calc_Intereses'
		PRINT 'Parametros:'
		PRINT 'FlagUsarTrans: ' + CONVERT(VARCHAR(10), @pFlagUsarTrans) + '. Id_Trans: ' + CONVERT(VARCHAR(10), @pId_Trans) + '. Imp_Total: ' + CONVERT(VARCHAR(10), @pImp_Total) + '. Imp_Abonado: ' + CONVERT(VARCHAR(10), @pImp_Abonado) + '. Fecha_Pago: ' + CONVERT(VARCHAR(10), @pFecha_Pago, 102)
	END
	
	/*===================================================================*/

	IF(@pId_Trans = 0)
	BEGIN
		SET @rtaErrorStored = 70001 /*Transaccion no abierta*/
		
		SELECT	 @rtaErrorStored	AS ErrorNumber 
				,0					AS ErrorSeverity  
				,0					AS ErrorState 
				,0					AS ErrorProcedure  
				,0					AS ErrorLine		
				,''					AS ErrorMessage
			
		IF @pFlagUsarTrans <> 0 
		BEGIN
			ROLLBACK
		END
		
		RETURN 9999
	END
	
	/*===================================================================*/	

	SET @Id_Producto			= ''
	SET @Descripcion			= ''
	SET @Importe				= 0
	SET @Periodo				= '19000101'
	SET @Porc_Bonif				= 0
	SET @Param_Prod_Recargos	= dbo.CF_xParam('PROD_RECARGOS')
	
	/*===================================================================*/	

	SET @Coef_Imp_Pagado = (@pImp_Abonado / @pImp_Total)

	SELECT	@Fecha_Factura		= ISNULL(Fecha, '19000101'),
			@Id_Cond_Pago_Cbte	= ISNULL(Id_Cond_Pago, 0)
		FROM	Cbtes
		WHERE	Id_Trans = @pId_Trans

	/*===================================================================*/	

	

	DECLARE curCPJ_Cbtes_Calc_Intereses_Cbtes_Items CURSOR FOR
		SELECT	Item,					ISNULL(Id_Producto, ''),		ISNULL(Id_Cond_Pago, 0),
				ISNULL(Imp_Final, 0),	ISNULL(Fecha_QA, '19000101')
				FROM	Cbtes_Items
				WHERE	Id_Trans = @pId_Trans
				
	OPEN curCPJ_Cbtes_Calc_Intereses_Cbtes_Items
	FETCH NEXT FROM curCPJ_Cbtes_Calc_Intereses_Cbtes_Items INTO @Item, @Id_Producto, @Id_Cond_Pago_Cbte_Item, @Imp_Final, @Fecha_QA
	WHILE @@FETCH_STATUS = 0
	BEGIN		

		IF(@Id_Cond_Pago_Cbte_Item <> 0)
		BEGIN
			SET @Plazo = 0
			SET @Porc_Bonif_Rec = 0
            SET @Fecha_Rec = @pFecha_Pago

            SET @Dif_Dias = DATEDIFF(dd, @Fecha_Factura, @Fecha_Rec)

			SET @Flag_Encontro = 0
			
			DECLARE curCPJ_Cbtes_Calc_Intereses_Cbtes_Items_Cond_Pago CURSOR FOR
				SELECT	ISNULL(Plazo_Desde, 0),
						ISNULL(Porc_Bonif, 0),
						ISNULL(Plazo_Bonif, 0),
						UPPER(ISNULL(Tipo, '')),
						ISNULL(Plazo_Sin_Recargo, 0)
					FROM	Cbtes_Cond_Pago_Items
					WHERE	Id_Cond_Pago = @Id_Cond_Pago_Cbte_Item


			OPEN curCPJ_Cbtes_Calc_Intereses_Cbtes_Items_Cond_Pago
			WHILE @@FETCH_STATUS = 0 AND @Flag_Encontro = 0
			BEGIN

				--Se rota la sentencia del Cursor para que corte cuando @Flag_Encontro = 1
				FETCH NEXT FROM curCPJ_Cbtes_Calc_Intereses_Cbtes_Items_Cond_Pago INTO @Plazo_Desde, @Porc_Bonif_Cbtes_Cond_Pago_Item, @Plazo_Bonif, @Tipo, @Plazo_Sin_Recargo

				IF(@Dif_Dias < 0 AND @Plazo_Desde = 0)
				BEGIN
					SET @Flag_Encontro = 1
					SET @Porc_Bonif_Rec = @Porc_Bonif_Cbtes_Cond_Pago_Item
					BREAK
				END

				IF(@Dif_Dias >= @Plazo_Desde AND @Dif_Dias <= @Plazo_Bonif)
				BEGIN
					SET @Flag_Encontro = 1
					SET @Porc_Bonif_Rec = @Porc_Bonif_Cbtes_Cond_Pago_Item
					BREAK
				END				
			END
			CLOSE curCPJ_Cbtes_Calc_Intereses_Cbtes_Items_Cond_Pago
			DEALLOCATE curCPJ_Cbtes_Calc_Intereses_Cbtes_Items_Cond_Pago

			IF(@pModoDebug = 1)
			BEGIN
				PRINT '@Flag_Encontro: ' + CONVERT(VARCHAR(10), @Flag_Encontro) 
					+ '. @Id_Cond_Pago_Cbte_Item: ' + CONVERT(VARCHAR(10), @Id_Cond_Pago_Cbte_Item) 
					+ '. @Id_Cond_Pago_Item: ' + CONVERT(VARCHAR(10), ISNULL(@Id_Cond_Pago_Item,0))
					+ '. @Porc_Bonif_Rec: ' + CONVERT(VARCHAR(10), @Porc_Bonif_Rec) 
					+ '. @Plazo_Bonif: ' + CONVERT(VARCHAR(10), @Plazo_Bonif) 
					+ '. @Fecha_Factura: ' + CONVERT(VARCHAR(10), @Fecha_Factura , 102) 
					+ ' @Fecha_Rec: ' + CONVERT(VARCHAR(10), @Fecha_Rec, 102) 
			END

			SELECT
				@Descripcion	= ISNULL(Descripcion_Detallada, ''),
				@Flag_Mes		= ISNULL(Flag_Mes, 0)
				FROM Productos
				WHERE
				Id_Producto = @Id_Producto

			IF(@Tipo = 'D'/*Descuento*/ AND @Porc_Bonif_Rec > 0 AND @Dif_Dias > @Plazo_Sin_Recargo)
			BEGIN
				SET @Importe = @Imp_Final * (@Porc_Bonif_Rec * (@Dif_Dias - @Plazo_Sin_Recargo) / 100)
			END
			ELSE
			BEGIN
				SET @Importe = @Imp_Final * (@Porc_Bonif_Rec / 100)
			END

			IF(@pModoDebug = 1)
			BEGIN
				PRINT '@Importe: ' + CONVERT(VARCHAR(10), @Importe) + '. Coef_Imp_Pagado: ' + CONVERT(VARCHAR(10), @Coef_Imp_Pagado)
			END

			IF @Coef_Imp_Pagado=0
			BEGIN
				SET @Coef_Imp_Pagado=1
			END

			SET @Importe =  @Importe * @Coef_Imp_Pagado
			SET @Porcentaje = ABS(@Porc_Bonif_Rec)

			IF(@pModoDebug = 1)
			BEGIN
				PRINT '@Porcentaje: ' + CONVERT(VARCHAR(10), @Porcentaje)
			END

			IF(@Flag_Mes = 1)
			BEGIN
				SET @Periodo = dbo.CF_FOMONTH(@Fecha_QA)
			END
			ELSE
			BEGIN
				SET @Periodo = '19000101'
			END
		END

		IF @Flag_Encontro = 1
		BEGIN
			IF(@Param_Prod_Recargos <> '')
			BEGIN
				SET @Id_Producto = @Param_Prod_Recargos
			END

			INSERT INTO @tRespuesta VALUES(@Id_Producto,@Descripcion,@Importe,@Periodo,@Porcentaje,@pId_Trans)
		END

		FETCH NEXT FROM curCPJ_Cbtes_Calc_Intereses_Cbtes_Items INTO @Item, @Id_Producto, @Id_Cond_Pago_Cbte_Item, @Imp_Final, @Fecha_QA
	END
	CLOSE curCPJ_Cbtes_Calc_Intereses_Cbtes_Items
	DEALLOCATE curCPJ_Cbtes_Calc_Intereses_Cbtes_Items

	/*===================================================================*/	
	
	IF @pFlagUsarTrans <> 0 
	BEGIN
		COMMIT
	END

	/*===================================================================*/	
	
	SELECT * FROM @tRespuesta

/*
	SET @rtaMsjStored		=	'{' +
								dbo.CF_Json_ParsearVariable('Id_Producto', @Id_Producto, 'VARCHAR(14)') + ',' +
								dbo.CF_Json_ParsearVariable('Descripcion', @Descripcion, 'VARCHAR(150)') + ',' +
								dbo.CF_Json_ParsearVariable('Importe', @Importe, 'DECIMAL(12,2)') + ',' +
								dbo.CF_Json_ParsearVariable('Periodo', @Periodo, 'DATETIME') + ',' +
								dbo.CF_Json_ParsearVariable('Porcentaje', @Porcentaje, 'DECIMAL(12,5)') + ',' +
								dbo.CF_Json_ParsearVariable('Id_Trans', @pId_Trans, 'INT') +
								'}'

	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,0				AS ErrorLine		
			,@rtaMsjStored	AS ErrorMessage
*/
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Cbtes_Calc_Intereses'
	END

END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0 
	BEGIN
		ROLLBACK
	END

	RETURN 9999
END CATCH

RETURN 0 

